# Core v5.2.9
**Release Date:** January 17, 2025  
**Tags:** FEATURE, BUG FIXES

## Fixed

### Authentication & Access Issues
- **Support Ticket Access**: Fixed 502 errors on admin support ticket page reloads
- **Authentication Middleware**: Fixed redirect loops and permission mismatches
- **Token Refresh**: Improved token refresh error handling and timeout management
- **Role Permissions**: Fixed role cache initialization causing permission check failures

### Logo Management System
- **Logo Display**: Fixed admin settings showing outdated database values instead of actual logo files
- **Hydration Errors**: Fixed hydration mismatch errors in logo field components
- **Logo Types**: Fixed incorrect logo type display (icon vs text logos)
- **Upload Failures**: Fixed logo upload issues in production environments
- **Path Resolution**: Fixed dark logo upload errors due to path structure differences

## Enhanced

### Authentication System  
- **Middleware**: Better error handling and timeout management in authentication middleware
- **Error Recovery**: Improved token refresh mechanism with better error recovery
- **Cache Validation**: Enhanced role fetching system with proper cache validation
- **Permission Checking**: Consistent error handling for admin route permissions

### Logo Management
- **File Display**: Logo components now display actual logo files instead of database settings
- **Preview System**: Proper hydration-safe rendering for logo previews
- **Path Resolution**: Intelligent fallback mechanisms for production environments
- **Directory Handling**: Multiple path attempts with comprehensive error handling

### System Improvements
- **Support Routing**: Simplified support ticket page routing structure
- **Production Compatibility**: Better production-ready path resolution across environments

## Added

### Advanced Logo Management System
- **Direct File Management**: Logo file replacement system in `/public/img/logo/` directory
- **Multiple Formats**: Automated PNG and WebP generation for all logo uploads
- **Size Processing**: Exact dimension requirements for each logo type
- **Bulk Updates**: Automatic updates of related files (favicons, Apple icons, etc.)

### Upload Interface
- **Drag-and-Drop**: Modern upload interface with live preview
- **File Validation**: Upload validation with file type and size checking
- **User Feedback**: Enhanced error handling and user feedback systems
- **Cache Management**: Automatic cache clearing after logo updates

### Logo Mapping System
- **Comprehensive Mapping**: Support for main logos, favicons, Apple icons, Android icons
- **Multiple Formats**: Support for various icon sizes (16x16 through 512x512)
- **Theme Support**: Dark and light theme logo variants
- **Database Integration**: Proper logo URL updates in settings database 