# Core v5.3.0
**Release Date:** January 17, 2025  
**Tags:** FEATURE, TRADING, ECOSYSTEM, BUG FIXES

## Fixed

### Trading & Market System
- **React Warnings**: Fixed React key prop warnings and hook order violations in withdraw forms
- **Market Navigation**: Fixed back button issues and infinite re-render loops in markets panel
- **Trading Interface**: Fixed duplicate backend path issues in custodial wallet creation
- **Market Priority**: Fixed ecosystem markets to take precedence over spot markets when symbols are identical

### Page Loading & Navigation
- **502 Errors**: Fixed Bad Gateway errors across multiple admin pages on refresh
- **SSR Issues**: Fixed server-side rendering failures in admin pages by adding proper client directives
- **KYC Pages**: Fixed KYC application pages returning Bad Gateway errors
- **Support System**: Fixed support ticket detail page 502 errors

### Withdrawal System
- **Currency Selection**: Fixed withdrawal form to handle multiple API response formats
- **Method Display**: Fixed empty fee badges and auto-selection issues in withdrawal methods
- **Balance Extraction**: Improved balance handling from various API response structures
- **Token Withdrawals**: Enhanced ecosystem token withdrawal method generation

### UI & Dark Mode
- **KYC Interface**: Fixed harsh button colors and improved dark mode styling across KYC pages
- **Mobile Layout**: Fixed KYC application drawer sizing and mobile responsiveness
- **Status Indicators**: Enhanced verification status badges and progress bars for dark mode

## Enhanced

### Ecosystem Trading Integration
- **Market Deduplication**: Ecosystem markets now automatically override duplicate spot markets
- **Trading Priority**: Enhanced trading system with intelligent market prioritization
- **Market Service**: Improved market data handling with ecosystem integration

### Withdrawal Experience
- **Multi-Currency Support**: Enhanced withdrawal system to support traditional and ecosystem currencies
- **Method Selection**: Improved withdrawal method cards with processing times and fee information
- **Token Support**: Full ecosystem token withdrawal support with proper address field generation

### Admin Interface
- **Responsive Design**: Improved mobile and desktop layouts for admin pages  
- **Error Handling**: Enhanced error handling and authentication guards
- **Navigation**: Improved routing and page loading across admin sections

### KYC System
- **Mobile Experience**: Enhanced mobile layout with proper tab navigation and scrolling
- **Dark Mode**: Complete dark mode support across all KYC application components
- **Interface Design**: Improved drawer-based interface for better content visibility

## Added

### Ecosystem Market Features
- **Market Priority System**: Automatic ecosystem market prioritization over spot markets
- **Advanced Deduplication**: Intelligent filtering for clean, non-duplicate market lists
- **Enhanced Interface**: Proper ecosystem market display with "Eco" badges

### Comprehensive Withdrawal System
- **Token Withdrawal Methods**: Full withdrawal support for ecosystem tokens with chain information
- **Fee Structure**: Advanced fee handling with fixed and percentage fee support
- **Multi-Format API**: Support for multiple currency API response formats

### KYC Application Enhancements
- **Drawer Interface**: 90% screen width drawer for maximum content visibility
- **Mobile Optimization**: Responsive design with tab-based navigation
- **Status Management**: Enhanced verification status tracking and display

### Support Ticket System  
- **Drawer Management**: Comprehensive drawer-based support ticket interface
- **Real-time Messaging**: Agent response capabilities with message history
- **Mobile Interface**: Optimized mobile layout with proper tab navigation