# Core v5.5.7

**Release Date:** October 21, 2025
**Tags:** CRITICAL FIXES, WITHDRAWAL SYSTEM, BALANCE CALCULATION

## Fixed

### Withdrawal System

- **Gas Fee Calculation**: Fixed NATIVE EVM token withdrawal fee calculation - gas fees now correctly paid from the withdrawal amount
  - Affected chains: ETH, BSC, POLYGON, FTM, OPTIMISM, ARBITRUM, BASE, CELO, RSK, AVAX
- **Max Withdrawal**: Fixed max withdrawal calculation to include gas fee estimation, preventing "Insufficient funds" errors
- **Balance Calculations**: Fixed critical balance calculation errors that caused incorrect withdrawal amounts
- **Decimal Precision**: Fixed floating-point precision errors in EVM chains (e.g., displaying 0.000890629999999999 instead of 0.00089063)
- **XMR Deposits**: Fixed Monero deposit deadlock issue preventing deposits from processing

### Private Ledger Integration

- **Balance Checks**: Fixed withdrawal balance checks to properly consider private ledger balances
- **Fee Protection**: Prevents users from withdrawing admin fees collected in cross-token exchanges

## Improved

### Gas Fee Management

- **Fee Reconciliation**: Improved gas fee reconciliation for NATIVE EVM withdrawals
  - Refunds difference if gas was overestimated
  - Deducts if gas was underestimated
  - Keeps balance synchronized with blockchain

### Balance Checking

- **Chain-Specific Amounts**: Improved balance checking to use chain-specific amounts
- **Gas Estimation**: Improved gas estimation for NATIVE EVM tokens before withdrawal with fallback to conservative estimates
