# ICO v5.1.8

**Release Date:** January 30, 2025
**Tags:** BUG FIXES, UI IMPROVEMENTS, DARK MODE

## Fixed

### ICO Offer Creation

- **Token Type Validation**: Fixed "Invalid token type" error with extra spaces when creating offers
- **Offer Submission**: Fixed token type value sending incorrectly causing validation failures

### Admin Offer Detail Page

- **Dark Mode**: Fixed admin ICO offer detail page showing white background in dark mode
- **Text Visibility**: Fixed all text colors not respecting dark mode theme
- **UI Components**: Fixed stat boxes, badges, and progress bars not respecting dark mode
- **Admin Actions**: Fixed missing admin action buttons (approve, reject, pause, resume, flag) not visible on offer detail page
- **Import Errors**: Fixed missing icon imports and ESLint routing errors

### Transaction Listing

- **SQL Error**: Fixed transaction listing endpoint database query error

## Improved

### Admin Offer Detail Page

- **Dark Mode Support**: Improved hero section with proper dark mode gradients and theme-aware colors
- **Admin Actions**: Added comprehensive admin actions card with all action buttons
- **Visual Consistency**: Enhanced card styling, layout spacing, and button grouping for better readability

### Architecture

- **Validation**: Simplified token type validation for better reliability
- **Error Messages**: Improved error messages for easier troubleshooting
- **Code Quality**: Reduced complex validation code for better maintainability
